<?php
session_start();
include('config.php');

if (isset($_FILES['summernoteimage'])) {
    $target_dir = "media/";
    $target_file = $target_dir . basename($_FILES["summernoteimage"]["name"]);
    $uploadOk = 1;
    $fileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    if ($fileType == "php" || $fileType == "html" || $fileType == "js") {
        $errormsg = "Sorry, this file type are not allowed.";
        $uploadOk = 0;
    }

    if ($uploadOk == 0) {
        echo json_response(500, $errormsg);
    }

    if (move_uploaded_file($_FILES["summernoteimage"]["tmp_name"], $target_file)) {
        echo json_response(200, home_url() . '/' . $target_file);
    }
}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'login') {
    $username = $userpassword = '';
    if (isset($_POST['username']))
        $username = $_POST['username'];
    if (isset($_POST['userpassword']))
        $userpassword = $_POST['userpassword'];
    $sql = $connection->prepare("SELECT * FROM users WHERE username=:username");
    $sql->bindParam("username", $username);
    $sql->execute();
    $user = $sql->fetch(PDO::FETCH_ASSOC);
    if ($user) {
        $userpass = $user["password"];
        if (password_verify($userpassword, $userpass)) {
            $_SESSION["username"] = $username;
            $_SESSION["status"] = "login";
            echo json_response(200, $_SESSION["username"]);
        } else {
            echo json_response(500, "incorrect username or password");
        }
    } else {
        echo json_response(500, "incorrect username or password");
    }
}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'setting') {
    $generalsettingsql = $connection->prepare("SELECT * FROM settings");
    $generalsettingsql->execute();
    $setting = $generalsettingsql->fetch(PDO::FETCH_ASSOC);
    $sitename = $setting['sitename'];
    if(isset($_POST['sitename'])) {
        $sitename = $_POST['sitename'];
        $updatesitename = "UPDATE settings SET sitename = '$sitename'";
        $connection->exec($updatesitename);
    }
    $sitetitle = $setting['sitetitle'];
    if(isset($_POST['site_title'])) {
        $sitetitle = $_POST['site_title'];
        $updatesitetitle = "UPDATE settings SET sitetitle = '$sitetitle'";
        $connection->exec($updatesitetitle);
    }
    $site_description = $setting['sitedesc'];
    if(isset($_POST['site_description'])) {
        $site_description = $_POST['site_description'];
        $updatesitedesc = "UPDATE settings SET sitedesc = '$site_description'";
        $connection->exec($updatesitedesc);
    }
    $site_keyword = $setting['site_keyword'];
    if(isset($_POST['site_keyword'])) {
        $site_keyword = $_POST['site_keyword'];
        $updatekeyword = "UPDATE settings SET site_keyword = '$site_keyword'";
        $connection->exec($updatekeyword);
    }
    $runningtext = $setting['runningtext'];
    if(isset($_POST['runningtext'])) {
        $runningtext = $_POST['runningtext'];
        $updaterunningtext = "UPDATE settings SET runningtext = '$runningtext'";
        $connection->exec($updaterunningtext);
    }
    $google_site_verification = $setting['google_site_verification'];
    if(isset($_POST['google_site_verification'])) {
        $google_site_verification = $_POST['google_site_verification'];
        $updategsv = "UPDATE settings SET google_site_verification = '$google_site_verification'";
        $connection->exec($updategsv);
    }
    $google_analytics_code = $setting['google_analytics_code'];
    if(isset($_POST['google_analytics_code'])) {
        $google_analytics_code = $_POST['google_analytics_code'];
        $updategac = "UPDATE settings SET google_analytics_code = '$google_analytics_code'";
        $connection->exec($updategac);
    }
    $homeGame = $_POST['homeGame'];
    $footertext = $_POST['footer_text'];
    $sitelogo = $setting['sitelogo'] ? $setting['sitelogo'] : '';
    if (isset($_FILES['site_logo'])) {
        $target_dir = "media/";
        $target_file = $target_dir . basename($_FILES["site_logo"]["name"]);
        $uploadOk = 1;
        $fileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        if ($fileType == "php" || $fileType == "html" || $fileType == "js") {
            $errormsg = "Sorry, this file type are not allowed.";
            $uploadOk = 0;
        }

        if ($uploadOk == 0) {
            echo json_response(500, $errormsg);
        }

        if (move_uploaded_file($_FILES["site_logo"]["tmp_name"], $target_file)) {
            $sitelogo = str_replace('media/', '', $target_file);
            $updatesitelogo = "UPDATE settings SET sitelogo = '$sitelogo'";
            $connection->exec($updatesitelogo);
        }
    } 
    $site_favicon = $setting['sitefavicon'] ? $setting['sitefavicon'] : '';
    if (isset($_FILES['site_favicon'])) {
        $target_dir = "media/";
        $target_file = $target_dir . basename($_FILES["site_favicon"]["name"]);
        $uploadOk = 1;
        $fileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        if ($fileType == "php" || $fileType == "html" || $fileType == "js") {
            $errormsg = "Sorry, this file type are not allowed.";
            $uploadOk = 0;
        }

        if ($uploadOk == 0) {
            echo json_response(500, $errormsg);
        }

        if (move_uploaded_file($_FILES["site_favicon"]["tmp_name"], $target_file)) {
            $site_favicon = str_replace('media/', '', $target_file);
            $updatefavicon = "UPDATE settings SET sitefavicon = '$site_favicon'";
            $connection->exec($updatefavicon);
        }
    } 
    $sitebanner = $setting['sitebanner'] ? $setting['sitebanner'] : '';
    if (isset($_FILES['sitebanner'])) {
        $target_dir = "media/";
        $target_file = $target_dir . basename($_FILES["sitebanner"]["name"]);
        $uploadOk = 1;
        $fileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        if ($fileType == "php" || $fileType == "html" || $fileType == "js") {
            $errormsg = "Sorry, this file type are not allowed.";
            $uploadOk = 0;
        }

        if ($uploadOk == 0) {
            echo json_response(500, $errormsg);
        }

        if (move_uploaded_file($_FILES["sitebanner"]["tmp_name"], $target_file)) {
            $sitebanner = str_replace('media/', '', $target_file);
            $updatesitebanner = "UPDATE settings SET sitebanner = '$sitebanner'";
            $connection->exec($updatesitebanner);
        }
    } 
    $footerlogo = $setting['footerlogo'] ? $setting['footerlogo'] : '';
    if (isset($_FILES['footerlogo'])) {
        $target_dir = "media/";
        $target_file = $target_dir . basename($_FILES["footerlogo"]["name"]);
        $uploadOk = 1;
        $fileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        if ($fileType == "php" || $fileType == "html" || $fileType == "js") {
            $errormsg = "Sorry, this file type are not allowed.";
            $uploadOk = 0;
        }

        if ($uploadOk == 0) {
            echo json_response(500, $errormsg);
        }

        if (move_uploaded_file($_FILES["footerlogo"]["tmp_name"], $target_file)) {
            $footerlogo = str_replace('media/', '', $target_file);
            $updatefooterlogo = "UPDATE settings SET footerlogo = '$footerlogo'";
            $connection->exec($updatefooterlogo);
        }
    } 
    $updatesql = "UPDATE settings SET homeGame = '$homeGame', footertext = '$footertext'";
    $connection->exec($updatesql);
    $data = [
        'logo' => $sitelogo,
        'favicon' => $site_favicon,
        'footerlogo' => $footerlogo,
        'banner' => $sitebanner
    ];
    echo json_response(200, $data);

}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'buttonlink') {
    $daftar = $_POST['daftarlink'];
    $login = $_POST['loginlink'];
    $lc = $_POST['livechatlink'];
    $data = [
        'daftar' => $daftar,
        'login' => $login,
        'lc' => $lc
    ];
    $updatesql = "UPDATE settings SET daftarlink = '$daftar', loginlink = '$login', livechat = '$lc'";
    $connection->exec($updatesql);
    echo json_response(200, $data);
}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'navmenu') {
    $navigation = $_POST['navigations'];
    if($navigation) {
        $navs = json_encode($navigation['navigations']);
        $updatesql = "UPDATE settings SET navigations = '$navs'";
        $connection->exec($updatesql); 
        echo json_response(200, $navs); 
    }
}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'bacapola') {
    $artikel = $_POST['artikel'];
    $updatesql = "UPDATE settings SET artikel = '$artikel'";
    $connection->exec($updatesql); 
    echo json_response(200, $artikel); 
}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'homeartikel') {
    $artikel = $_POST['artikel'];
    $updatesql = "UPDATE settings SET artikelhome = '$artikel'";
    $connection->exec($updatesql); 
    echo json_response(200, $artikel); 
}

if (isset($_POST['tipe']) && $_POST['tipe'] == 'socialmedia') {
    $socialMedia = '';
    if(isset($_POST['medsos']) && !empty($_POST['medsos'])) $socialMedia = json_encode($_POST['medsos'], true);
    $updatesql = "UPDATE settings SET sosmed = '$socialMedia'";
    $connection->exec($updatesql); 
    echo json_response(200, $socialMedia); 
}