<?php
session_start();
if (!isset($_SESSION["username"])) {
    header('Location: /login.php');
    exit;
}

include('config.php');
?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Dashboard | Setting</title>
    <link href="assets/vendor/fontawesome/css/fontawesome.min.css" rel="stylesheet">
    <link href="assets/vendor/fontawesome/css/solid.min.css" rel="stylesheet">
    <link href="assets/vendor/fontawesome/css/brands.min.css" rel="stylesheet">
    <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/vendor/summernote/summernote-lite.min.css" rel="stylesheet">
    <link href="assets/css/master.css" rel="stylesheet">
</head>

<body>
    <style>
        /*image gallery*/
        .image-checkbox {
            cursor: pointer;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            border: 4px solid transparent;
            margin-bottom: 0;
            outline: 0;
            position: relative;
        }

        .image-checkbox input[type="radio"] {
            display: none;
        }

        .image-checkbox-checked {
            border-color: #4783B0;
        }

        .image-checkbox .fa {
            display: none;
            position: absolute;
            color: #4A79A3;
            background-color: #fff;
            padding: 10px;
            top: 0;
            right: 0;
        }

        .image-checkbox-checked .fa {
            display: block !important;
        }

        .submitted {
            display: none;
        }

        .imgbank {
            position: relative;
        }

        .imgbank .removeImg {
            display: none;
            position: absolute;
            background: rgba(255, 255, 255, 0.7);
            width: 100%;
            height: 100%;
            align-items: center;
            justify-content: center;
        }

        .imgbank:hover .removeImg {
            display: flex;
        }

        .imgbank .removeImg .fas {
            cursor: pointer;
            color: red;
            font-size: 1.5rem;
        }

        #updatebanks {
            width: 120px;
        }
    </style>
    <div class="wrapper">
        <!-- sidebar navigation component -->
        <?php //include('sidebar.php'); 
        ?>
        <!-- end of sidebar component -->
        <div id="body" class="active">
            <!-- navbar navigation component -->
            <?php include('navbar.php'); ?>
            <!-- end of navbar navigation -->
            <div class="content">
                <div class="container">
                    <?php
                    $settings = $connection->prepare("SELECT * FROM settings");
                    $settings->execute();
                    $setting = $settings->fetch(PDO::FETCH_ASSOC);
                    $sitename = $sitetitle = $sitedesc = $site_keyword = $google_site_verification = $logo = $favicon = $sitebanner = $headscript = $footerlogo = $footertext = $daftarlink = $loginlink = $livechat = $runningtext = $artikelhome = '';
                    if (isset($setting['sitename']))
                        $sitename = $setting['sitename'];
                    if (isset($setting['sitetitle']))
                        $sitetitle = $setting['sitetitle'];
                    if (isset($setting['sitedesc']))
                        $sitedesc = $setting['sitedesc'];
                    if (isset($setting['site_keyword']))
                        $site_keyword = $setting['site_keyword'];
                    if (isset($setting['google_site_verification']))
                        $google_site_verification = $setting['google_site_verification'];
                    if (isset($setting['sitelogo']))
                        $logo = $setting['sitelogo'];
                    if (isset($setting['sitefavicon']))
                        $favicon = $setting['sitefavicon'];
                    if (isset($setting['sitebanner']))
                        $sitebanner = $setting['sitebanner'];
                    if (isset($setting['google_analytics_code']))
                        $headscript = $setting['google_analytics_code'];
                    if (isset($setting['footerlogo']))
                        $footerlogo = $setting['footerlogo'];
                    if (isset($setting['footertext']))
                        $footertext = $setting['footertext'];
                    if (isset($setting['daftarlink']))
                        $daftarlink = $setting['daftarlink'];
                    if (isset($setting['loginlink']))
                        $loginlink = $setting['loginlink'];
                    if (isset($setting['livechat']))
                        $livechat = $setting['livechat'];
                    if (isset($setting['runningtext']))
                        $runningtext = $setting['runningtext'];
                    if (isset($setting['popgameVal']))
                        $popgameVal = $setting['popgameVal'];
                    if (isset($setting['artikelhome']))
                        $artikelhome = $setting['artikelhome'];
                    ?>
                    <div class="page-title">
                        <div class="row">
                            <div class="col-md-8">
                                <h3>Settings</h3>
                            </div>
                            <div class="col-md-4">
                                <div class="text-end my-2"><a href="<?php echo home_url(); ?>" class="btn btn-primary" target="_blank">view site</a></div>
                            </div>
                        </div>
                    </div>
                    <div class="box box-primary">
                        <div class="box-body">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="general-tab" data-bs-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">General</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="buttonlink-tab" data-bs-toggle="tab" href="#buttonlink" role="tab" aria-controls="buttonlink" aria-selected="false">Button Link</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="navmenu-tab" data-bs-toggle="tab" href="#navmenu" role="tab" aria-controls="navmenu" aria-selected="false">Navigation Menu</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="bacapola-tab" data-bs-toggle="tab" href="#bacapola" role="tab" aria-controls="bacapola" aria-selected="false">Baca Pola</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="homeArtikel-tab" data-bs-toggle="tab" href="#homeArtikel" role="tab" aria-controls="homeArtikel" aria-selected="false">Home Artikel</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="sosmed-tab" data-bs-toggle="tab" href="#sosmed" role="tab" aria-controls="sosmed" aria-selected="false">Social Media</a>
                                </li>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade active show" id="general" role="tabpanel" aria-labelledby="general-tab">
                                    <div class="alert alert-success submitted" role="alert">
                                        Settings Saved
                                    </div>
                                    <div class="col-md-12">
                                        <form id="general">
                                            <p class="text-muted">General settings such as, site title, site
                                                description,
                                                address and so on.</p>
                                            <div class="mb-3">
                                                <label for="sitename" class="form-label">Site Name</label>
                                                <input type="text" name="sitename" class="form-control" value="<?php echo $sitename; ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label for="site-title" class="form-label">Site Title</label>
                                                <input type="text" name="site_title" class="form-control" value="<?php echo $sitetitle; ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label for="site-description" class="form-label">Site
                                                    Description</label>
                                                <textarea class="form-control" name="site_description"><?php echo $sitedesc; ?></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label for="site_keyword" class="form-label">Keyword</label>
                                                <input type="text" name="site_keyword" class="form-control" value="<?php echo $site_keyword; ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Site Logo</label>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <div class="sitelogo">
                                                            <img id="sitelogo" src="media/<?php echo $logo; ?>" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <input class="form-control" name="site_logo" type="file" id="formFile1">
                                                <small class="text-muted">The image must have a maximum size of
                                                    1MB</small>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Favicon</label>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <div class="sitefavicon">
                                                            <img id="sitefavicon" style="height:60px" src="media/<?php echo $favicon; ?>" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <input class="form-control" name="site_favicon" type="file" id="formFile2">
                                                <small class="text-muted">The image must have a maximum size of
                                                    1MB</small>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Google Analytics Code</label>
                                                <textarea class="form-control" name="google_analytics_code" rows="4"><?php echo $headscript; ?></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label for="google_site_verification" class="form-label">Google Site
                                                    Verification</label>
                                                <textarea class="form-control" name="google_site_verification"><?php echo $google_site_verification; ?></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Running Text</label>
                                                <textarea class="form-control mb-3" name="runningtext" rows="2" placeholder="Running Text"><?php echo $runningtext; ?></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Banner</label>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <div class="sitebanner mb-3">
                                                            <img id="sitebanner" src="media/<?php echo $sitebanner; ?>" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <input class="form-control" name="sitebanner" type="file" id="formFile1">
                                                <small class="text-muted">The image must have a maximum size of
                                                    1MB</small>
                                            </div>
                                            <div class="mb-3">
                                                <label for="homeGame" class="form-label">Home Game</label>
                                                <select class="form-select" name="homeGame">
                                                    <?php
                                                    $navigations = $setting['navigations'];
                                                    if ($navigations) {
                                                        $navs = json_decode($navigations, true);
                                                        $selected = '';
                                                        if ($setting['homeGame'] == $nav['navSlug'])
                                                            $selected = 'selected';
                                                        foreach ($navs as $nav) {
                                                            echo '<option value="' . $nav['navSlug'] . '" ' . $selected . '>' . $nav['navTitle'] . '</option>';
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label for="popgameVal" class="form-label">Popular Game minimal
                                                    value</label>
                                                <input type="number" name="popgameVal" class="form-control" placeholder="only number" value="<?php echo $popgameVal; ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Footer Content</label>
                                                <div class="mb-3">
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <div class="logofooter">
                                                                <img id="logofooter" style="height:60px" src="media/<?php echo $footerlogo; ?>" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <input class="form-control" name="footerlogo" type="file" id="footerlogo">
                                                    <small class="text-muted">Footer Logo. The image must have a maximum
                                                        size of
                                                        1MB</small>
                                                </div>
                                                <textarea class="form-control mb-3" name="footer_text" rows="2" placeholder="Copyright Text"><?php echo $footertext; ?></textarea>
                                            </div>
                                            <div class="mb-3 text-end">
                                                <button class="btn btn-success" type="submit">
                                                    Save
                                                    <i class="fas fa-check" style="display:none"></i><span class="spinner-border spinner-border-sm" role="status" style="display:none"><span class="visually-hidden">Loading...</span></span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="buttonlink" role="tabpanel" aria-labelledby="buttonlink-tab">
                                    <div class="alert alert-success submitted" role="alert">
                                        Settings Saved
                                    </div>
                                    <div class="col-md-12">
                                        <p class="text-muted">Button Link Settings</p>
                                        <form id="buttonlink">
                                            <div class="mb-3">
                                                <label for="daftarlink" class="form-label">Daftar Link</label>
                                                <input type="text" name="daftarlink" class="form-control" value="<?php echo $daftarlink; ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label for="loginlink" class="form-label">Login Link</label>
                                                <input type="text" name="loginlink" class="form-control" value="<?php echo $loginlink; ?>">
                                            </div>
                                            <div class="mb-3">
                                                <label for="livechatlink" class="form-label">Livechat Link</label>
                                                <input type="text" name="livechatlink" class="form-control" value="<?php echo $livechat; ?>">
                                            </div>
                                            <div class="mb-3 text-end">
                                                <button class="btn btn-success" type="submit">
                                                    Save
                                                    <i class="fas fa-check" style="display:none"></i><span class="spinner-border spinner-border-sm" role="status" style="display:none"><span class="visually-hidden">Loading...</span></span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="navmenu" role="tabpanel" aria-labelledby="navmenu-tab">
                                    <div class="col-md-12">
                                        <p class="text-muted">Navigation Menu</p>
                                        <form id="navmenu">
                                            <div class="mb-3">
                                                <div id="navMenu">
                                                    <div class="mb-3" data-repeater-list="navigations">
                                                        <?php
                                                        $navigations = $setting['navigations'];
                                                        if ($navigations) {
                                                            $navs = json_decode($navigations, true);
                                                            foreach ($navs as $nav) { ?>
                                                                <div class="row" data-repeater-item>
                                                                    <div class="col-md-3">
                                                                        <label>Menu Title</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Menu Title" name="navTitle" value="<?php echo $nav['navTitle']; ?>">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Menu Slug</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Menu Slug" name="navSlug" value="<?php echo $nav['navSlug']; ?>">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Game Link</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Game Link" name="gamelink" value="<?php echo $nav['gamelink']; ?>">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Alternate Link</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Alternate Game Link" name="altgamelink" value="<?php echo $nav['altgamelink']; ?>">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Link to Game Page</label>
                                                                        <select class="form-select" name="linking">
                                                                            <option value="yes" <?php if ($nav['linking'] == 'yes')
                                                                                                    echo 'selected'; ?>>Yes</option>
                                                                            <option value="no" <?php if ($nav['linking'] == 'no')
                                                                                                    echo 'selected'; ?>>No</option>
                                                                        </select>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Menu Icon</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="icon menu link" name="menuIcon" value="<?php echo $nav['menuIcon']; ?>">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Mobile Title</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Mobile Menu Title" name="mblTitle" value="<?php echo $nav['mblTitle']; ?>">
                                                                    </div>
                                                                    <!--
                                                                    <div class="col-md-3">
                                                                        <label>Top Game</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="id with comma separated" name="topgame" value="<?php echo $nav['topgame']; ?>">
                                                                    </div>
                                                                    -->
                                                                    <div class="col-md-3">
                                                                        <label>Popular Game</label>
                                                                        <input class="form-control col-md-6 mb-3" placeholder="id with comma separated" type="text" name="popgame" value="<?php echo $nav['popgame']; ?>" />
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Hide Game</label>
                                                                        <input class="form-control col-md-6 mb-3" placeholder="id with comma separated" type="text" name="hidegame" value="<?php echo $nav['hidegame']; ?>" />
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Page Title</label>
                                                                        <input class="form-control col-md-6 mb-3" placeholder="Page Title" type="text" name="pagetitle" value="<?php echo $nav['pagetitle']; ?>" />
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Page Description</label>
                                                                        <textarea class="form-control" name="pagedesc"><?php echo $nav['pagedesc']; ?></textarea>
                                                                    </div>
                                                                    <div class="col-md-12">
                                                                        <input type="hidden" value="<?php $nav['randNumb']; ?>" name="randNumb">
                                                                        <input class="btn btn-danger col-md-3 mb-3" data-repeater-delete type="button" value="Delete" />
                                                                    </div>
                                                                </div>
                                                            <?php
                                                            }
                                                        } else { ?>
                                                            <div class="mb-3" data-repeater-item>
                                                                <div class="row">
                                                                    <div class="col-md-3">
                                                                        <label>Menu Title</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Menu Title" name="navTitle">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Menu Slug</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Menu Slug" name="navSlug">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Game Link</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Game Link" name="gamelink">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Alternate Link</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Alternate Game Link" name="altgamelink">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Link to Game Page</label>
                                                                        <select class="form-select" name="linking">
                                                                            <option value="yes">Yes</option>
                                                                            <option value="no">No</option>
                                                                        </select>
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Menu Icon</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="icon menu link" name="menuIcon">
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Mobile Title</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="Mobile Menu Title" name="mblTitle">
                                                                    </div>
                                                                    <!--
                                                                    <div class="col-md-3">
                                                                        <label>Top Game</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="id with comma separated" name="topgame">
                                                                    </div>
                                                                    -->
                                                                    <div class="col-md-3">
                                                                        <label>Popular Game</label>
                                                                        <input class="form-control col-md-6 mb-3" placeholder="id with comma separated" type="text" name="popgame" />
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Hide Game</label>
                                                                        <input class="form-control col-md-6 mb-3" placeholder="id with comma separated" type="text" name="hidegame" />
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Page Title</label>
                                                                        <input class="form-control col-md-6 mb-3" placeholder="Page Title" type="text" name="pagetitle" />
                                                                    </div>
                                                                    <div class="col-md-3">
                                                                        <label>Page Description</label>
                                                                        <textarea class="form-control" name="pagedesc"></textarea>
                                                                    </div>
                                                                    <div class="col-md-12">
                                                                        <?php
                                                                        $numbers = range(0, 1000);
                                                                        shuffle($numbers);
                                                                        $randNumb = implode(',', $numbers);
                                                                        ?>
                                                                        <input type="hidden" value="" name="randNumb">
                                                                        <input class="btn btn-danger col-md-3 mb-3" data-repeater-delete type="button" value="Delete" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                    <div class="my-3">
                                                        <input class="btn btn-success" data-repeater-create type="button" value="Add Menu" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-3 text-end">
                                                <button class="btn btn-success" type="submit">
                                                    Save
                                                    <i class="fas fa-check" style="display:none"></i><span class="spinner-border spinner-border-sm" role="status" style="display:none"><span class="visually-hidden">Loading...</span></span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="bacapola" role="tabpanel" aria-labelledby="bacapola-tab">
                                    <div class="alert alert-success submitted" role="alert">
                                        Settings Saved
                                    </div>
                                    <div class="col-md-12">
                                        <p class="text-muted">Baca Pola Content</p>
                                        <form id="bacapolaForm">
                                            <div class="mb-3">
                                                <textarea id="bacaPola" class="summernote" name="artikel"><?php echo $setting['artikel']; ?></textarea>
                                            </div>
                                            <div class="mb-3 text-end">
                                                <button class="btn btn-success" type="submit">
                                                    Save
                                                    <i class="fas fa-check" style="display:none"></i><span class="spinner-border spinner-border-sm" role="status" style="display:none"><span class="visually-hidden">Loading...</span></span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="homeArtikel" role="tabpanel" aria-labelledby="homeArtikel-tab">
                                    <div class="alert alert-success submitted" role="alert">
                                        Settings Saved
                                    </div>
                                    <div class="col-md-12">
                                        <p class="text-muted">Home Artikel</p>
                                        <form id="homeArtikelForm">
                                            <div class="mb-3">
                                                <textarea id="artikelhome" class="summernote" name="artikelhome"><?php echo $artikelhome; ?></textarea>
                                            </div>
                                            <div class="mb-3 text-end">
                                                <button class="btn btn-success" type="submit">
                                                    Save
                                                    <i class="fas fa-check" style="display:none"></i><span class="spinner-border spinner-border-sm" role="status" style="display:none"><span class="visually-hidden">Loading...</span></span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="sosmed" role="tabpanel" aria-labelledby="sosmed-tab">
                                    <div class="col-md-12">
                                        <p class="text-muted">Social Media</p>
                                        <form id="medsos">
                                            <div class="mb-3">
                                                <div id="socMed">
                                                    <div class="mb-3" data-repeater-list="medsos">
                                                        <?php
                                                        $sosmeds = json_decode($setting['sosmed'], true);
                                                        if ($sosmeds) {
                                                            foreach ($sosmeds as $sosmed) {
                                                                if ($sosmed['sosmedTitle']) $sosmedtitle = $sosmed['sosmedTitle'];
                                                                if ($sosmed['sosmedlink']) $sosmedlink = $sosmed['sosmedlink'];
                                                                if ($sosmed['sosmedIcon']) $sosmedicon = $sosmed['sosmedIcon'];
                                                        ?>
                                                                <div class="row" data-repeater-item>
                                                                    <div class="col-md-4">
                                                                        <label>Social Media Title</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="facebook" name="sosmedTitle" value="<?php echo $sosmedtitle; ?>">
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label>Social Media Link</label>
                                                                        <input type="text" class="form-control mb-3" placeholder="https://facebook.com" name="sosmedlink" value="<?php echo $sosmedlink; ?>">
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label>Icon <small>(find icon <a style="color:blue" href="https://fontawesome.com/v5/search" rel="nofollow" target="_blank">here</a>)</small></label>
                                                                        <input type="text" class="form-control mb-3" placeholder="fa-facebook-square" name="sosmedIcon" value="<?php echo $sosmedicon; ?>">
                                                                    </div>
                                                                    <div class="col-md-12">
                                                                        <input class="btn btn-danger col-md-3 mb-3" data-repeater-delete type="button" value="Delete" />
                                                                    </div>
                                                                </div>
                                                            <?php
                                                            }
                                                        } else { ?>
                                                            <div class="row" data-repeater-item>
                                                                <div class="col-md-4">
                                                                    <label>Social Media Title</label>
                                                                    <input type="text" class="form-control mb-3" placeholder="facebook" name="sosmedTitle">
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <label>Social Media Link</label>
                                                                    <input type="text" class="form-control mb-3" placeholder="https://facebook.com" name="sosmedlink">
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <label>Icon <small>(find icon <a style="color:blue" href="https://fontawesome.com/v5/search" rel="nofollow" target="_blank">here</a>)</small></label>
                                                                    <input type="text" class="form-control mb-3" placeholder="fa-facebook-square" name="sosmedIcon">
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <input class="btn btn-danger col-md-3 mb-3" data-repeater-delete type="button" value="Delete" />
                                                                </div>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                    <div class="my-3">
                                                        <input class="btn btn-success" data-repeater-create type="button" value="Add Social Media" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-3 text-end">
                                                <button class="btn btn-success" type="submit">
                                                    Save
                                                    <i class="fas fa-check" style="display:none"></i><span class="spinner-border spinner-border-sm" role="status" style="display:none"><span class="visually-hidden">Loading...</span></span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="assets/vendor/jquery/jquery.min.js"></script>
    <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/jquery.repeater.min.js"></script>
    <script src="assets/vendor/summernote/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.summernote').summernote({
                height: 300,
                callbacks: {
                    onImageUpload: function(image, editor, welEditable) {
                        uploadImage(image[0], editor, welEditable);
                    }
                }
            });
        });

        function uploadImage(image, editor, welEditable) {
            var formData = new FormData();
            formData.append("summernoteimage", image);
            console.log(image)
            $.ajax({
                url: 'ajax.php',
                cache: false,
                contentType: false,
                processData: false,
                data: formData,
                type: "post",
                success: function(resp) {
                    var url = resp.message
                    console.log(url)
                    var image = $('<img>').attr('src', url);
                    $('.summernote').summernote("insertNode", image[0]);
                },
                error: function(data) {
                    console.log(data);
                }
            });
        }

        function shuffle(array) {
            let currentIndex = array.length,
                randomIndex;

            // While there remain elements to shuffle.
            while (currentIndex != 0) {

                // Pick a remaining element.
                randomIndex = Math.floor(Math.random() * currentIndex);
                currentIndex--;

                // And swap it with the current element.
                [array[currentIndex], array[randomIndex]] = [
                    array[randomIndex], array[currentIndex]
                ];
            }

            return array;
        }
        $('#navMenu').repeater({
            //initEmpty: true,
            show: function() {
                $(this).slideDown();
            },
            hide: function(deleteElement) {
                if (confirm('Are you sure you want to delete this element?')) {
                    $(this).slideUp(deleteElement);
                }
            },
        })
        $('#socMed').repeater({
            show: function() {
                $(this).slideDown();
            },
            hide: function(deleteElement) {
                if (confirm('Are you sure you want to delete this element?')) {
                    $(this).slideUp(deleteElement);
                }
            },
        })
        $('form#general').submit(function(e) {
            e.preventDefault()
            $('form#general').find('.spinner-border').fadeIn()
            var form = $('form#general')[0];
            var formData = new FormData(form)
            formData.append('tipe', 'setting')
            //var template= $('input[name=template]:checked').val()
            //formData.append('tipe', 'settings')
            //formData.append('template', template)
            $.ajax({
                url: 'ajax.php',
                type: 'POST',
                data: formData,
                cache: false,
                processData: false,
                contentType: false,
                success: function(response) {
                    $('form#general').find('.spinner-border').hide()
                    $('form#general').find('.fas').show()
                    $('form#general .submitted').slideDown()
                    $('#formFile1').val('')
                    $('#formFile2').val('')
                    $('#footerlogo').val('')
                    $('#sitelogo').attr('src', 'media/' + response.message.logo)
                    $('#sitefavicon').attr('src', 'media/' + response.message.favicon)
                    $('#logofooter').attr('src', 'media/' + response.message.footerlogo)
                    $('#sitebanner').attr('src', 'media/' + response.message.banner)
                    setTimeout(function() {
                        $('form#general .submitted').slideUp()
                        $('form#general').find('.fas').fadeOut()
                    }, 3000)
                }
            })
        })

        $('form#buttonlink').submit(function(e) {
            e.preventDefault()
            var form = $('form#buttonlink')[0];
            var formData = new FormData(form)
            formData.append('tipe', 'buttonlink')
            $.ajax({
                url: 'ajax.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $('form#buttonlink').find('.spinner-border').hide()
                    $('form#buttonlink').find('.fas').show()
                    $('form#buttonlink .submitted').slideDown()
                    setTimeout(function() {
                        $('form#buttonlink .submitted').slideUp()
                        $('form#buttonlink').find('.fas').fadeOut()
                    }, 3000)
                }
            })
        })

        $('form#navmenu').submit(function(e) {
            e.preventDefault()
            $('form#navmenu .spinner-border').show()
            var navcontent = ($('#navMenu').repeaterVal())

            for (n = 0; n < navcontent['navigations'].length; n++) {
                var numbRand = shuffle(Array.from({
                    length: 1000
                }, (x, i) => parseInt(i)))
                if (navcontent['navigations'][n].randNumb == '') {
                    navcontent['navigations'][n].randNumb = shuffle(numbRand)
                }
            }
            $.ajax({
                url: 'ajax.php',
                type: 'POST',
                data: {
                    tipe: 'navmenu',
                    navigations: navcontent
                },
                dataType: 'json',
                success: function(response) {
                    $('form#navmenu').find('.spinner-border').hide()
                    $('form#navmenu').find('.fas').show()
                    $('form#navmenu .submitted').slideDown()
                    setTimeout(function() {
                        $('form#navmenu .submitted').slideUp()
                        $('form#navmenu').find('.fas').fadeOut()
                    }, 2000)
                }
            })
        })

        $('form#bacapolaForm').submit(function(e) {
            e.preventDefault()
            $('form#bacapolaForm .spinner-border').show()
            var artikel = $('#bacaPola').val()
            $.ajax({
                url: 'ajax.php',
                type: 'POST',
                data: {
                    tipe: 'bacapola',
                    artikel: artikel
                },
                dataType: 'json',
                success: function(response) {
                    $('form#bacapolaForm').find('.spinner-border').hide()
                    $('form#bacapolaForm').find('.fas').show()
                    $('form#bacapolaForm .submitted').slideDown()
                    setTimeout(function() {
                        $('form#bacapolaForm .submitted').slideUp()
                        $('form#bacapolaForm').find('.fas').fadeOut()
                    }, 2000)
                }
            })
        })

        $('form#homeArtikelForm').submit(function(e) {
            e.preventDefault()
            $('form#homeArtikelForm .spinner-border').show()
            var artikel = $('#artikelhome').val()
            $.ajax({
                url: 'ajax.php',
                type: 'POST',
                data: {
                    tipe: 'homeartikel',
                    artikel: artikel
                },
                dataType: 'json',
                success: function(response) {
                    $('form#homeArtikelForm').find('.spinner-border').hide()
                    $('form#homeArtikelForm').find('.fas').show()
                    $('form#homeArtikelForm .submitted').slideDown()
                    setTimeout(function() {
                        $('form#homeArtikelForm .submitted').slideUp()
                        $('form#homeArtikelForm').find('.fas').fadeOut()
                    }, 2000)
                }
            })
        })

        var sosmeds = ''
        $('form#medsos').submit(function(e) {
            e.preventDefault()
            $('form#medsos .spinner-border').show()
            var form = $('form#medsos')[0];
            var formData = new FormData(form)
            formData.append('tipe', 'socialmedia')
            $.ajax({
                url: 'ajax.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $('form#medsos').find('.spinner-border').hide()
                    $('form#medsos').find('.fas').show()
                    $('form#medsos .submitted').slideDown()
                    setTimeout(function() {
                        $('form#medsos .submitted').slideUp()
                        $('form#medsos').find('.fas').fadeOut()
                    }, 2000)
                }
            })
        })
    </script>
</body>

</html>