<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Install | RTP CMS</title>
    <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/auth.css" rel="stylesheet">
</head>

<body>
    <div class="wrapper">
        <div class="auth-content">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-4">
                        <img class="brand" src="assets/images/logo.png" alt="RTP logo">
                    </div>
                    <h6 class="mb-4 text-muted">Lets get started the installation</h6>
                    <?php 
                        if(isset($_POST['install'])) {
                            if(isset($_POST['username'])) {
                                $username = $_POST['username'];
                            } 
                            if(isset($_POST['password'])) {
                                $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
                            } 
                            if(isset($_POST['dbname'])) {
                                $dbname = $_POST['dbname'];
                            } 
                            if(isset($_POST['dbusername'])) {
                                $dbusername = $_POST['dbusername'];
                            } 
                            if(isset($_POST['dbpassword'])) {
                                $dbpassword = $_POST['dbpassword'];
                            } 
                            if(isset($_POST['dbhost'])) {
                                $dbhost = $_POST['dbhost'];
                            } 

                            $env = 'USER='.$dbusername.'
                            PASSWORD='.$dbpassword.'
                            HOST='.$dbhost.'
                            DATABASE='.$dbname;

                            file_put_contents('.env', $env);

                            define('SITEDIR', realpath($_SERVER["DOCUMENT_ROOT"]));
                            require_once('class.environment.php');
                            $__DotEnvironment = new DotEnvironment(SITEDIR."/.env");

                            define('USER', $_ENV['USER']);
                            define('PASSWORD', $_ENV['PASSWORD']);
                            define('HOST', $_ENV['HOST']);
                            define('DATABASE', $_ENV['DATABASE']);

                            try {
                                $connection = new PDO("mysql:host=".HOST.";dbname=".DATABASE.";charset=utf8mb4;", USER, PASSWORD);
                            } catch(PDOException $e) {
                                exit("ERROR: " . $e->getMessage());
                            }

                            $usersql = "CREATE TABLE users (
                                id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
                                username varchar(255),
                                password varchar(255)
                            )"; 
                            $connection->query($usersql);
                            $insertuser = "INSERT INTO users (username, password)
                            VALUES ('$username', '$password')"; 
                            $connection->query($insertuser);

                            $settingsql = "CREATE TABLE settings (
                                sitename varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                sitetitle varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                sitedesc varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                site_keyword varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                google_site_verification varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                sitelogo varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                sitefavicon varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                sitebanner varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                google_analytics_code varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                homeGame varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                popgameVal int(9) COLLATE utf8mb4_general_ci DEFAULT 65,
                                footerlogo varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                sosmed json,
                                footertext varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                daftarlink varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                loginlink varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                livechat varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                runningtext varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
                                navigations json,
                                artikel text COLLATE utf8mb4_general_ci DEFAULT NULL,
                                artikelhome text COLLATE utf8mb4_general_ci DEFAULT NULL
                                
                            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
                            $connection->query($settingsql);
                            
                            $artikel = '<h3 class="text-center mb-3">Cara membaca pola RTP</h3>
                            <p>Untuk pola spin yang kami berikan merupakan sebuah pola yang kami rangkum sedemikan rupa dari hasil riset
                                yang kami lakukan dan di bagikan secara real time kepada semua player.</p>
                            <p>Pola yang kami berikan dapat berubah sewaktu" karena akan di update terus dengan pola terbaru dan terbaik
                                yang akan kami berikan kepada anda semua. Jadi pastikan untuk selalu mengecek pola gacor yang kami
                                berikan setiap waktu saat anda ingin bermain.</p>
                            <p>Untuk kamu yang bingung bagaimana cara membaca pola slot gacor yang kami berikan, berikut adalah
                                penjelasan detailnya :</p>
                            <div class="text-center mb-5">
                                <img src="https://polasuhuslot.com/assets/images/gambar1.png" alt="tutorial" class="img-fluid">
                            </div>
                            <p>Kita masuk ke bagian pola spin gacor, disini ada tanda silang dan tanda ceklis serta berapa putaran yang
                                bisa kamu lakukan, dan juga ada DC off / on, DC ini adalah Duoble Chance ( Peluang Ganda). Contoh :
                            </p>
                            <div class="text-center mb-5">
                                <img src="https://polasuhuslot.com/assets/images/gambar2.png" alt="tutorial" class="img-fluid">
                            </div>
                            <p>Kamu bisa lihat disini pola pertama, kemudian kamu bisa aplikasikan ke games yang kamu mainkan seperti
                                ini dan silahkan di lanjutkan ke pola selanjutnya jika memang pola sebelumnya sudah diselesaikan.</p>
                            <div class="text-center mb-5">
                                <img src="https://polasuhuslot.com/assets/images/gambar3.png" alt="tutorial" class="img-fluid">
                            </div>
                            <p>Sedangkan untuk DC on/off tersebut bisa di perhatikan pada bagian ini : </p>
                            <div class="text-center mb-5">
                                <img src="https://polasuhuslot.com/assets/images/gambar4.png" alt="tutorial" class="img-fluid">
                            </div>
                            <p>Jika petunjuk dari pola gacor adalah DC off maka kamu bisa nonaktifkan DC ini, sedangkan untuk DC on maka
                                kamu bisa aktifkan dengan cara mengklik tombol hijau tersebut.</p>
                            <p>Jika memang ada yang kurang kamu pahami, maka kamu juga bisa masuk ke bagian livechat yang telah kami
                                sediakan sebagai support tambahan yang online 24 jam siap memberikan pelayanan dengan ramah dan baik
                                kepada kamu semua.</p>
                            <p>Perlu di ingat bahwa pola yang kami berikan merupakan tips tambahan dan bukan merupakan sebuah patokkan
                                pasti untuk mendapatkan sebuah kemenangan, karena pada dasarnya hoki lah penentu sebenarnya untuk bisa
                                mendapatkan kemenangan. Untuk pola gacor yang kami berikan berfungsi sebagai petunjuk untuk kamu yang
                                bingung dalam menentukan pola untuk bermain dengan baik dan benar. jika kamu memiliki trik dan pola yang
                                kamu anggap bisa lebih baik dan memiliki kesempatan lebih besar untuk menang, maka kami menyarankan
                                untuk menggunakan pola tersebut.</p><p></p>';
                            $insertsetting = "INSERT INTO settings (sitename, sitetitle, sitedesc, site_keyword, google_site_verification, sitelogo, sitefavicon, homeGame, popgameVal, footerlogo, footertext, daftarlink, livechat, runningtext, artikel)
                            VALUES (
                                'polamonster.test', 
                                'Pola Monster', 
                                'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 
                                'pola, monster',
                                'eD0EVHd-97eDPBCP4xKLLpX1a2ucHgs34byxZ93WQFk',
                                'logo.png',
                                'favicon.png',
                                'pragmatic',
                                '65',
                                'favicon.png',
                                'Copyright © MONSTERBOLA - 2020. All Rights Reserved',
                                'https://monsterbola43.com/register',
                                'https://lc.chat/now/12650310/',
                                'Info Bocoran Slot Gacor ini dibuat berdasarkan permainan pada situs Monsterbola. Tidak di sarankan untuk menggunakan informasi ini pada situs lain selain situs terpercaya Monsterbola.',
                                '$artikel')"; 
                            $connection->query($insertsetting);

                            echo '<meta content=”0; url=login.php” http-equiv=”refresh”>';
                            exit();
                        }
                    ?>
                    <form action="install.php" method="POST">
                        <div class="mb-3 text-start">
                            <input type="text" class="form-control" name="username" placeholder="User Name" required>
                        </div>
                        <div class="mb-3 text-start">
                            <input type="password" class="form-control" name="password" placeholder="Password" required>
                        </div>
                        <div class="mb-3 text-start">
                            <input type="text" class="form-control" name="dbname" placeholder="Data Base Name" required>
                        </div>
                        <div class="mb-3 text-start">
                            <input type="text" class="form-control" name="dbusername" placeholder="Data Base User Name" required>
                        </div>
                        <div class="mb-3 text-start">
                            <input type="text" class="form-control" name="dbpassword" placeholder="Data Base Password">
                        </div>
                        <div class="mb-3 text-start">
                            <input type="text" class="form-control" name="dbhost" placeholder="Host Name" required>
                        </div>
                        <button name="install" class="btn btn-primary shadow-2 mb-4">Install</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="assets/vendor/jquery/jquery.min.js"></script>
    <script src="assets/vendor/bootstrap/js/bootstrap.min.js"></script>
    <script>
/*        jQuery(document).ready(function() {
            $('form').submit(function(e) {
                e.preventDefault()
                var tipe = 'install'
                var username = $("input[name=username]").val()
                var userpassword = $("input[name=password]").val()
                var dbname = $("input[name=dbname]").val()
                var dbusername = $("input[name=dbusername]").val()
                var dbname = $("input[name=dbname]").val()
                var dbusername = $("input[name=dbusername]").val()
                $.ajax({
                    url: 'ajax.php',
                    type: 'GET',
                    dataType: 'json',
                    data: {tipe:tipe, username:username, userpassword:userpassword},
                    success: function(response) {
                        window.location.href = '/dashboard.php'
                    },
                    error: function(err) {
                        alert(err.responseJSON.message)
                    }
                })
            })
        }) */
    </script>
</body>

</html>