<?php 
	$navigations = $setting['navigations'];
	if ($navigations) { 
		$navs = json_decode($navigations, true); ?>
		<div class="game-menu">
			<ul class="nav nav-desktop owl-carousel">
				<?php foreach($navs as $nav) : ?>
					<?php if($nav['navSlug'] == $setting['homeGame']) : ?>
						<li class="nav-item">
							<a class="nav-link" href="/">
								<div class="slot-item">
									<img src="<?php echo $nav['menuIcon']; ?>" alt="<?php echo $nav['navTitle']; ?>">
								</div>
								<div class="slot-text"><?php echo $nav['navTitle']; ?></div>
							</a>
						</li>
					<?php else : ?>
						<li class="nav-item">
							<a class="nav-link" href="/<?php echo $nav['navSlug']; ?>">
							<div class="slot-item">
									<img src="<?php echo $nav['menuIcon']; ?>" alt="<?php echo $nav['navTitle']; ?>">
								</div>
								<div class="slot-text"><?php echo $nav['navTitle']; ?></div>
							</a>
						</li>
					<?php endif; ?>
				<?php endforeach; ?>
			</ul>
			<ul class="nav nav-mobile owl-carousel">
				<?php 
					foreach(array_chunk($navs, 10) as $navis) {
						echo '<li class="nav-item clearfix">';
						foreach($navis as $nav) { ?>
							<a class="nav-link mb-2" href="/<?php echo $nav['navSlug']; ?>">
								<div class="slot-item">
									<img src="<?php echo $nav['menuIcon']; ?>" alt="<?php echo $nav['navTitle']; ?>">
								</div>
								<div class="slot-text"><?php echo $nav['navTitle']; ?></div>
							</a><?php 
						}
						echo '</li>';
					}
				?>
			</ul>
		</div><?php 
	}
?>
